package 你的包名;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;

import androidx.annotation.Nullable;

import 你的包名.ApiResponse;
import 你的包名.TokenData;

import java.util.HashMap;
import java.util.Map;

public class LoginActivity extends Activity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //使用示例，如果是RSA混合模式，必须设置公钥，如果是AES模式，必须设置AESkey
        Api.getInstance().setPublicKey(Constants.PUBLIC_KEY);
        Api.getInstance().setAesKey(Constants.AES_KEY);
        Map<String, Object> params = new HashMap<>();
        Api.getInstance().getToken(params,new ApiCallback<TokenData>() {
            @Override
            public void onSuccess(ApiResponse<TokenData> response) {
                // 获取 Token 成功
                TokenData tokenData = response.getData();
                String token = tokenData.getToken();
                String aesKey = tokenData.getCryptoKeyAes();
                String ip = tokenData.getIP();

                Log.d("aaa",token);
                // 保存 token 和 aesKey
//                api.getInstance().setAesKey(aesKey);
//                api.getInstance().setToken(token);
            }

            @Override
            public void onFailure(Throwable throwable) {
                // 处理错误
                throwable.printStackTrace();
            }
        });
    }
}
