package 你的包名;

import android.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EncryptUtils {
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding"; // 修改为CBC模式
    private static final int AES_KEY_SIZE = 24; // 192位
    private static final byte[] IV = new byte[16]; // 16位空字节数组
    private static final String MD5_ALGORITHM = "MD5";
    private static final String RSA_ALGORITHM = "RSA";  // KeyFactory 只需要基础算法名称
    private static final String RSA_CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";  // Cipher 需要完整的算法描述

      public static String genAesKey() {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder key = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < AES_KEY_SIZE; i++) {
            key.append(chars.charAt(random.nextInt(chars.length())));
        }
        return key.toString();
    }

    public static Map<String, String> encryptWithRSA(String data, String aesKey,String publicKey) throws Exception {
        // AES加密原始数据
        SecretKeySpec secretKey = new SecretKeySpec(aesKey.getBytes(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher aesCipher = Cipher.getInstance(AES_ALGORITHM);
        aesCipher.init(Cipher.ENCRYPT_MODE, secretKey, ivSpec);
        byte[] encryptedData = aesCipher.doFinal(data.getBytes());
        String encryptedDataBase64 = Base64.encodeToString(encryptedData, Base64.NO_WRAP);

        // RSA加密AES密钥
        byte[] keyBytes = Base64.decode(publicKey, Base64.DEFAULT);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);

        Cipher rsaCipher = Cipher.getInstance(RSA_CIPHER_ALGORITHM);
        rsaCipher.init(Cipher.ENCRYPT_MODE, pubKey);
        byte[] encryptedAesKey = rsaCipher.doFinal(aesKey.getBytes());
        String encryptedAesKeyBase64 = Base64.encodeToString(encryptedAesKey, Base64.NO_WRAP);

        Map<String, String> result = new HashMap<>();
        result.put("a", encryptedDataBase64);
        result.put("b", encryptedAesKeyBase64);
        return result;
    }

    public static Map<String, String> encryptWithAES(String data, String aesKey) throws Exception {
        // AES加密原始数据
        SecretKeySpec secretKey = new SecretKeySpec(aesKey.getBytes(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher aesCipher = Cipher.getInstance(AES_ALGORITHM);
        aesCipher.init(Cipher.ENCRYPT_MODE, secretKey, ivSpec);
        byte[] encryptedData = aesCipher.doFinal(data.getBytes());

        // Base64编码加密后的数据得到密文a
        String encryptedDataBase64 = Base64.encodeToString(encryptedData, Base64.NO_WRAP);

        // MD5(密文a+AES密钥)得到签名b
        String signContent = encryptedDataBase64 + aesKey;
        MessageDigest md = MessageDigest.getInstance(MD5_ALGORITHM);
        byte[] signBytes = md.digest(signContent.getBytes());
        String signature = bytesToHex(signBytes);

        Map<String, String> result = new HashMap<>();
        result.put("a", encryptedDataBase64);
        result.put("b", signature);
        return result;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

      /**
     * 生成大于10000的随机状态码
     * @return 随机状态码
     */
    public static int genRandomStatus() {
        return new SecureRandom().nextInt(90000) + 10001;
    }


    /**
     * RSA解密响应数据
     *
     * @param encryptedData   加密的响应数据(a值)
     * @param encryptedAesKey RSA加密的AES密钥(b值)
     * @param publicKey       RSA公钥
     * @return 解密后的数据
     */
    public static String decryptWithRSA(String encryptedData, String encryptedAesKey, String publicKey) throws Exception {
        // 1. 用RSA公钥解密b值获取AES密钥
        byte[] keyBytes = Base64.decode(publicKey, Base64.DEFAULT);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);

        Cipher rsaCipher = Cipher.getInstance(RSA_CIPHER_ALGORITHM);
        rsaCipher.init(Cipher.DECRYPT_MODE, pubKey);
        byte[] encryptedAesKeyBytes = Base64.decode(encryptedAesKey, Base64.DEFAULT);
        byte[] aesKey = rsaCipher.doFinal(encryptedAesKeyBytes);

        // 2. 用解密出的AES密钥解密a值
        SecretKeySpec secretKey = new SecretKeySpec(aesKey, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher aesCipher = Cipher.getInstance(AES_ALGORITHM);
        aesCipher.init(Cipher.DECRYPT_MODE, secretKey, ivSpec);

        byte[] encryptedDataBytes = Base64.decode(encryptedData, Base64.DEFAULT);
        byte[] decryptedData = aesCipher.doFinal(encryptedDataBytes);

        return new String(decryptedData);
    }

    /**
     * AES解密响应数据
     * @param encryptedData 加密的响应数据(a值)
     * @param signature 签名(b值)
     * @param aesKey AES密钥
     * @return 解密后的数据
     * @throws Exception 当签名验证失败或解密失败时抛出异常
     */
    public static String decryptWithAES(String encryptedData, String signature, String aesKey) throws Exception {
        // 1. 验证签名
        String signContent = encryptedData + aesKey;
        MessageDigest md = MessageDigest.getInstance(MD5_ALGORITHM);
        byte[] signBytes = md.digest(signContent.getBytes());
        String calculatedSignature = bytesToHex(signBytes).toUpperCase();
        
        if (!calculatedSignature.equals(signature.toUpperCase())) {
            throw new Exception("Signature verification failed");
        }
        
        // 2. AES解密数据
        SecretKeySpec secretKey = new SecretKeySpec(aesKey.getBytes(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(IV);
        Cipher aesCipher = Cipher.getInstance(AES_ALGORITHM);
        aesCipher.init(Cipher.DECRYPT_MODE, secretKey, ivSpec);
        
        byte[] encryptedDataBytes = Base64.decode(encryptedData, Base64.DEFAULT);
        byte[] decryptedData = aesCipher.doFinal(encryptedDataBytes);
        
        return new String(decryptedData);
    }
}