/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import org.opencv.android.CameraBridgeViewBase;

public class CameraActivity
extends Activity {
    private static final int CAMERA_PERMISSION_REQUEST_CODE = 200;

    protected List<? extends CameraBridgeViewBase> getCameraViewList() {
        return new ArrayList();
    }

    protected void onCameraPermissionGranted() {
        List<? extends CameraBridgeViewBase> cameraViews = this.getCameraViewList();
        if (cameraViews == null) {
            return;
        }
        for (CameraBridgeViewBase cameraBridgeViewBase : cameraViews) {
            if (cameraBridgeViewBase == null) continue;
            cameraBridgeViewBase.setCameraPermissionGranted();
        }
    }

    protected void onStart() {
        super.onStart();
        boolean havePermission = true;
        if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.CAMERA") != 0) {
            this.requestPermissions(new String[]{"android.permission.CAMERA"}, 200);
            havePermission = false;
        }
        if (havePermission) {
            this.onCameraPermissionGranted();
        }
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 200 && grantResults.length > 0 && grantResults[0] == 0) {
            this.onCameraPermissionGranted();
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }
}

